// the table object will contain the data from our TSV file.
var table;

// two dimensional array holding [date in Date format, total number of passengers]
var data;

// hold the earliest date, latest date, and date range in seconds
var earliestDate, latestDate, dateRange;

// retain the highest daily passenger count
var highestCount = 0;

// hold the horizontal and vertical scale
var xScale, yScale;
var chartWidth = 1000;
var chartHeight = 500;
var xOffset = 50;
var yOffset = 50;
var increment = 1000;

// the preload function occurs once before setup(), and is used for loading
// assets that will be utilized by the sketch.
function preload(){
  // loadTable() creates an object that holds the data from a TSV file.
  table = loadTable("trips.tsv", "tsv", "header");
}

// setup is automatically called once when the page loads.
function setup(){
  // createCanvas() creates the canvas element we will be drawing to.
  var canvas = createCanvas(1100, 700);
  canvas.parent("sketch");

  // save the first and last date to establish the date range.
  earliestDate = new Date(table.getString(0, 1));
  latestDate = new Date(table.getString(table.getRowCount()-1, 1));
  dateRange = latestDate.getTime() - earliestDate.getTime();

  // put the earliest date in our data array to start it off with 0 passengers.
  data = [[earliestDate, 0]];

  // cycle through the table
  for (var r=0; r<table.getRowCount(); r++){
    var row = table.getRow(r);
    var date = new Date(row.get(1));
    var passengers = parseInt(row.get(0));

    // check if this date equals the last date in our data array.
    if(date.getTime() === data[data.length-1][0].getTime()){
      // increase the passenger count.
      data[data.length-1][1] += passengers;
    } else {
      // if this day's passenger count is higher than the previous highest, record it.
      if(data[data.length-1][1] > highestCount){
        highestCount = data[data.length-1][1];
      }
      //console.log(data[data.length-1][0], data[data.length-1][1]);
      // record the passengers from this new day.
      data.push([date, passengers]);
    }
  }

  // establish scale of the chart.
  xScale = chartWidth / dateRange;
  yScale = chartHeight / highestCount;

  noLoop();
}

function draw(){

  textSize(10);

  // get the # of passengers remaining after rounding to the nearest 1000.
  var rem = highestCount % 1000;
  // draw the vertical year bars behind our data
  for(var i=earliestDate.getFullYear(); i<=latestDate.getFullYear(); i++){
    var d = new Date(str(i));
    stroke(220,92);
    var x = (d.getTime() - earliestDate.getTime()) * xScale;
    line(x + xOffset, chartHeight + yOffset + 5, x + xOffset, yOffset + (rem * yScale));
    // draw year at a 45 degree angle
    push();
    translate(x + xOffset - 5, chartHeight + yOffset + 7);
    rotate(PI/4);
    text(i,0,0);
    pop();
  }

  // draw the horizontal passenger count bars behind our data
  for(var i=0; i<highestCount; i += increment){
    stroke(192,92);
    var y = int(chartHeight - (i * yScale) + yOffset);
    line(xOffset, y, chartWidth+xOffset, y);
    noStroke();
    text(i, width - xOffset + 5, y + 3);
  }

  stroke(200,173,127);
  for(var i=0; i<data.length; i++){
    var d = data[i][0];   // Date object
    var p = data[i][1];   // passenger count
    // horizontal position based on date, vertical position based on passenger count.
    var x = (d.getTime() - earliestDate.getTime()) * xScale;
    var y = chartHeight - (p * yScale);
    line(x + xOffset, y + yOffset, x + xOffset, chartHeight + yOffset);
  }

  // draw labels
  textAlign(CENTER);
  textSize(14);
  noStroke();
  text("Daily Passenger Count through Ellis Island, 1892 - 1928", width/2, 30);


}
