// the table object will contain the data from our CSV file.
var table;

// the preload function occurs once before setup(), and is used for loading
// assets that will be utilized by the sketch.
function preload(){
  // loadTable() creates an object that holds the data from a CSV file.
  table = loadTable("films.csv", "csv", "header");
}


// setup is automatically called once when the page loads.
function setup(){
  // createCanvas() creates the canvas element we will be drawing to.
  var canvas = createCanvas(640, 480);
  canvas.parent("sketch");

  // output the number of rows and columns to the console.
  console.log(table.getRowCount() + " total rows in table");
  console.log(table.getColumnCount() + " total columns in table");

  // cycle through the table
  for (var r=0; r<table.getRowCount(); r++){
    for (var c=0; c<table.getColumnCount(); c++) {
      console.log(table.getString(r, c));
    }
  }
}
